using System;
using Server;

namespace Xanthos.Evo
{
	public sealed class RaelisDemonioSpec : BaseEvoSpec
	{
		// This class implements a singleton pattern; meaning that no matter how many times the
		// Instance attribute is used, there will only ever be one of these created in the entire system.
		// Copy this template and give it a new name.  Assign all of the data members of the EvoSpec
		// base class in the constructor.  Your subclass must not be abstract.
		// Never call new on this class, use the Instance attribute to get the instance instead.

		RaelisDemonioSpec()
		{
			m_Tamable = true;
			m_MinTamingToHatch = 70.0;
			m_PercentFemaleChance = 0.02;	// Made small to limit access to eggs.
			m_GuardianEggOrDeedChance = 0.30;
			m_AlwaysHappy = true;
			m_ProducesYoung = true;
			m_PregnancyTerm = 0.10;
			m_AbsoluteStatValues = false;
			m_MaxEvoResistance = 100;
			m_MaxTrainingStage = 7;
			m_CanAttackPlayers = false;

			m_Skills = new SkillName[9] { SkillName.Magery, SkillName.EvalInt, SkillName.Meditation, SkillName.MagicResist,
										  SkillName.Tactics, SkillName.Wrestling, SkillName.Anatomy, SkillName.AnimalLore, SkillName.Veterinary };
			m_MinSkillValues = new int[9] { 50, 50, 50, 29, 29, 29, 29, 29, 29 };
			m_MaxSkillValues = new int[9] { 100, 100, 100, 100, 100, 100, 100, 100, 100 };

			m_Stages = new BaseEvoStage[] { new RaelisDemonioStageOne(), new RaelisDemonioStageTwo(),
											  new RaelisDemonioStageThree(), new RaelisDemonioStageFour(),
											  new RaelisDemonioStageFive(), new RaelisDemonioStageSix(),
											  new RaelisDemonioStageSeven() };
		}

		// These next 2 lines  facilitate the singleton pattern.  In your subclass only change the
		// BaseEvoSpec class name to your subclass of BaseEvoSpec class name and uncomment both lines.
		public static RaelisDemonioSpec Instance { get { return Nested.instance; } }
		class Nested { static Nested() { } internal static readonly RaelisDemonioSpec instance = new RaelisDemonioSpec();}
	}	

	// Define a subclass of BaseEvoStage for each stage in your creature and place them in the
	// array in your subclass of BaseEvoSpec.  See the example classes for how to do this.
	// Your subclass must not be abstract.

	public class RaelisDemonioStageOne : BaseEvoStage
	{
		public RaelisDemonioStageOne()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 25000; EpMinDivisor = 80; EpMaxDivisor = 60; DustMultiplier = 20;
			BaseSoundID = 422;
			BodyValue = 74; ControlSlots = 3; MinTameSkill = 99.9; VirtualArmor = 15;

			DamagesTypes = new ResistanceType[1] { ResistanceType.Physical };
			MinDamages = new int[1] { 100 };
			MaxDamages = new int[1] { 100 };

			ResistanceTypes = new ResistanceType[1] { ResistanceType.Physical };
			MinResistances = new int[1] { 15 };
			MaxResistances = new int[1] { 15 };

			DamageMin = 12; DamageMax = 15; HitsMin = 200; HitsMax = 250;
			StrMin = 190; StrMax = 216; DexMin = 80; DexMax = 84; IntMin = 140; IntMax = 156;
		}
	}

	public class RaelisDemonioStageTwo : BaseEvoStage
	{
		public RaelisDemonioStageTwo()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 75000; EpMinDivisor = 200; EpMaxDivisor = 150; DustMultiplier = 20;
			BaseSoundID = 219;
			BodyValue = 89; VirtualArmor = 30;
		
			DamagesTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
													ResistanceType.Poison, ResistanceType.Energy };
			MinDamages = new int[5] { 100, 25, 25, 25, 25 };
			MaxDamages = new int[5] { 100, 25, 25, 25, 25 };

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 20, 20, 20, 20, 20 };
			MaxResistances = new int[5] { 20, 20, 20, 20, 20 };

			DamageMin = 2; DamageMax = 2; HitsMin= 500; HitsMax = 500;
			StrMin = 130; StrMax = 130; DexMin = 55; DexMax = 55; IntMin = 50; IntMax = 50;
		}
	}

	public class RaelisDemonioStageThree : BaseEvoStage
	{
		public RaelisDemonioStageThree()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 175000; EpMinDivisor = 600; EpMaxDivisor = 500; DustMultiplier = 20;
			BaseSoundID = 377;
			BodyValue = 22; VirtualArmor = 40;
		
			DamagesTypes = null;
			MinDamages = null;
			MaxDamages = null;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 45, 40, 40, 40, 40 };
			MaxResistances = new int[5] { 45, 40, 40, 40, 40 };

			DamageMin = 1; DamageMax = 2; HitsMin= 100; HitsMax = 100;
			StrMin = 80; StrMax = 80; DexMin = 30; DexMax = 30; IntMin = 20; IntMax = 20;
		}
	}

	public class RaelisDemonioStageFour : BaseEvoStage
	{
		public RaelisDemonioStageFour()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 3750000; EpMinDivisor = 750; EpMaxDivisor = 500; DustMultiplier = 20;
			BaseSoundID = 0x3E9;
			BodyValue = 24; ControlSlots = 4; MinTameSkill = 119.9; VirtualArmor = 55;
		
			DamagesTypes = null;
			MinDamages = null;
			MaxDamages = null;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 55, 50, 50, 50, 50 };
			MaxResistances = new int[5] { 55, 50, 50, 50, 50 };	

			DamageMin = 3; DamageMax = 4; HitsMin= 100; HitsMax = 100;
			StrMin = 100; StrMax = 100; DexMin = 80; DexMax = 80; IntMin = 120; IntMax = 120;
		}
	}

	public class RaelisDemonioStageFive : BaseEvoStage
	{
		public RaelisDemonioStageFive()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 7750000; EpMinDivisor = 1500; EpMaxDivisor = 1200; DustMultiplier = 20;
			BodyValue = 0x310; VirtualArmor = 70;
		
			DamagesTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
													 ResistanceType.Poison, ResistanceType.Energy };
			MinDamages = new int[5] { 60, 50, 50, 50, 50 };
			MaxDamages = new int[5] { 60, 50, 50, 50, 50 };

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 85, 80, 80, 80, 80 };
			MaxResistances = new int[5] { 85, 80, 80, 80, 80 };	

			DamageMin = 3; DamageMax = 4; HitsMin= 100; HitsMax = 100;
			StrMin = 50; StrMax = 50; DexMin = 30; DexMax = 30; IntMin = 150; IntMax = 150;
		}
	}

	public class RaelisDemonioStageSix : BaseEvoStage
	{
		public RaelisDemonioStageSix()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 15000000; EpMinDivisor = 5500; EpMaxDivisor = 4100; DustMultiplier = 20;
			BodyValue = 149; VirtualArmor = 130;
		
			DamagesTypes = null;
			MinDamages = null;
			MaxDamages = null;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 90, 85, 85, 85, 85 };
			MaxResistances = new int[5] { 90, 85, 85, 85, 85 };	

			DamageMin = 5; DamageMax = 7; HitsMin= 100; HitsMax = 100;
			StrMin = 40; StrMax = 40; DexMin = 40; DexMax = 40; IntMin = 30; IntMax = 30;
		}
	}

	public class RaelisDemonioStageSeven : BaseEvoStage
	{
		public RaelisDemonioStageSeven()
		{
			Title = "The Ancient Daemon";
			EvolutionMessage = "has evolved to its highest form and is now an Ancient Daemon";
			NextEpThreshold = 0; EpMinDivisor = 150000; EpMaxDivisor = 100000; DustMultiplier = 20;
			BaseSoundID = 362;
			BodyValue = 102; ControlSlots = 4; VirtualArmor = 180;
		
			DamagesTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
													 ResistanceType.Poison, ResistanceType.Energy };
			MinDamages = new int[5] { 100, 75, 75, 75, 75 };
			MaxDamages = new int[5] { 100, 75, 75, 75, 75 };

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 95, 90, 90, 90, 90 };
			MaxResistances = new int[5] { 95, 90, 90, 90, 90 };	

			DamageMin = 6; DamageMax = 7; HitsMin= 1150; HitsMax = 1200;
			StrMin = 50; StrMax = 50; DexMin = 50; DexMax = 50; IntMin = 70; IntMax = 85;
		}
	}
}